import keypad
import board
import usb_hid
import time
from adafruit_hid.keyboard import Keyboard
from adafruit_hid.keycode import Keycode
from supervisor import ticks_ms

def check_press(anterior):
    novo = ticks_ms()
    return (novo - anterior) < 1000

time.sleep(1)
kbd = Keyboard(usb_hid.devices)

# 8 Rows 5 Columns. Note rows are not in order
km = keypad.KeyMatrix(
    row_pins=(board.GP5, board.GP6, board.GP8, board.GP9, board.GP10, board.GP7, board.GP11, board.GP12),
    column_pins=(board.GP0, board.GP1, board.GP2, board.GP3, board.GP4),
)

key_ZX81 = {0 : Keycode.FIVE,
            1 : Keycode.FOUR,
            2 : Keycode.THREE,
            3 : Keycode.TWO,
            4 : Keycode.ONE,

            5 : Keycode.T,
            6 : Keycode.R,
            7 : Keycode.E,
            8 : Keycode.W,
            9 : Keycode.Q,

            10 : Keycode.SIX,
            11 : Keycode.SEVEN,
            12 : Keycode.EIGHT,
            13 : Keycode.NINE,
            14 : Keycode.ZERO,

            15 : Keycode.Y,
            16 : Keycode.U,
            17 : Keycode.I,
            18 : Keycode.O,
            19 : Keycode.P,

            20 : Keycode.V,
            21 : Keycode.C,
            22 : Keycode.X,
            23 : Keycode.Z,
            24 : Keycode.LEFT_SHIFT,

            25 : Keycode.G,
            26 : Keycode.F,
            27 : Keycode.D,
            28 : Keycode.S,
            29 : Keycode.A,

            30 : Keycode.H,
            31 : Keycode.J,
            32 : Keycode.K,
            33 : Keycode.L,
            34 : Keycode.ENTER,

            35 : Keycode.B,
            36 : Keycode.N,
            37 : Keycode.M,
            38 : Keycode.RIGHT_CONTROL,
            39 : Keycode.SPACE,
           }
event = keypad.Event()

shift = False           # True if shift pressed
double_count = 0        # Counts shift press-release pairs that are in time
double_tick = 0         # millisecond tick of the last time that the shift key was released
double_converted = 0    # The converted key code sent as a result of a double press
double_original = 0     # The original key press that triggered the double press

while True:
    if km.events.get_into(event):
        key_code = key_ZX81.get(event.key_number, 0)

        if key_code != 0:
            if event.pressed:
                if key_code == Keycode.LEFT_SHIFT:
                    shift = True
                    if double_count:
                        if not check_press(double_tick):
                           double_count = 0
                    double_count += 1
                    kbd.press(Keycode.LEFT_SHIFT)
                else:
                    if double_count > 1:
                       if check_press(double_tick):
                           if key_code >= Keycode.ONE and key_code <= Keycode.ZERO:
                              double_converted = Keycode.F1 + (key_code - Keycode.ONE)
                           if key_code == Keycode.SPACE:
                              double_converted = Keycode.ESCAPE
                           if key_code == Keycode.ENTER:
                              double_converted = Keycode.TAB
                           double_original = key_code
                           key_code = double_converted
                    kbd.press(key_code)
                    double_count = 0
            else:
                if key_code == Keycode.LEFT_SHIFT:
                    if double_count:
                        double_tick = ticks_ms()
                    shift = False
                    kbd.release(Keycode.LEFT_SHIFT)
                if key_code == double_original:
                    kbd.release(double_converted)
                    double_original = 0
                else:
                    kbd.release(key_code)

